// ------------------------------------------------------------
// Shaders for Q3Rally GFX Textures - rewritten by P3rlE
// based on several q3r_xxx.shader from quake3rally
// ------------------------------------------------------------

// ------------------------------------------------------------
// 1.hud (arrow)
// ------------------------------------------------------------

gfx/hud/arrow

{
	cull none

	{
		map gfx/hud/arrow.tga
		blendfunc add
		rgbGen identity
	}
}

// ------------------------------------------------------------
// 2.region
// ------------------------------------------------------------

// the REGION shader is generated by the map editor on temporary
// brushes around a selected area for testing parts of maps

textures/REGION
{
	surfaceparm nolightmap
}

// ------------------------------------------------------------
// 3.lagometer (the background for the netgraph)
// ------------------------------------------------------------

lagometer
{
	nopicmip
	{
		map gfx/2d/lag.tga
	}
}

// blinked on top of lagometer when connection is interrupted

disconnected
{
	nopicmip
	{
		map gfx/2d/net.tga
	}
}

white
{
	{
		map *white
		blendfunc	GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen vertex
	}
}

// ------------------------------------------------------------
// 4.console
// ------------------------------------------------------------

console
{
	nopicmip
	nomipmaps
    
        {
		map gfx/misc/screen01.tga
                blendFunc GL_ONE GL_ZERO
                tcMod scroll 7.1  0.2
                tcmod scale .8 1
	}
        {
		map gfx/misc/console01.tga
                blendFunc Add
                
	}
        

}

// ------------------------------------------------------------
// 5.menu
// ------------------------------------------------------------

menuback
{
	nopicmip
	nomipmaps

        {
                map textures/sfx/menucar01.tga
        }

       
        
}
menubacknologo
{
	nopicmip
	nomipmaps
       
        {
               map gfx/colors/black.tga
	} 
        
}

menubacknologo2
{
	nopicmip
	nomipmaps
	{
		map menu/art/menu_back.tga
	} 
}

menubackRagePro	// blends turn to shit on rage pro, so skip it
{
	nopicmip
	nomipmaps
        {
                map textures/sfx/menucar01.tga
        }
        
}

// ------------------------------------------------------------
// 6.levelshot detail (used to break up the blur on levelshots)
// ------------------------------------------------------------

levelShotDetail
{
	nopicmip
	{
		map textures/sfx/detail.tga
        	blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
	}
}

// ------------------------------------------------------------
// 7.menu 2D gfx
// ------------------------------------------------------------

gfx/2d/menuinfo
{
	nopicmip
	{
		map gfx/2d/menuinfo.tga
	}
}

gfx/2d/menuinfo2
{
	nopicmip
	{
		map gfx/2d/menuinfo2.tga
	}
}

gfx/2d/quit
{
	nopicmip
	nomipmaps
	{
		map gfx/2d/quit.tga
	}
}

gfx/2d/cursor
{
    nopicmip
	nomipmaps
    {
        map gfx/2d/cursor.tga
    }
}

// ------------------------------------------------------------
// 8.chat icon
// ------------------------------------------------------------

sprites/balloon3
{
	{
		map sprites/balloon3.tga
		blendfunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

// ------------------------------------------------------------
// 9.teamplay icons
// ------------------------------------------------------------

sprites/foe
{
	nomipmaps
	nopicmip
	{
		map sprites/foe2.tga
		blendfunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

sprites/friend
{
	nomipmaps
	nopicmip
	{
		map sprites/friend1.tga
		blendfunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

// ------------------------------------------------------------
// 10.misc effects
// ------------------------------------------------------------

textures/sfx/beam
{
        surfaceparm trans	
        surfaceparm nomarks	
        surfaceparm nonsolid
	surfaceparm nolightmap
	cull none
	//surfaceparm nomipmaps
        //nopicmip
	{
		map textures/sfx/beam.tga
                tcMod Scroll .3 0
                blendFunc add
        }
        // {
	//	map textures/sfx/beam.tga
        //        tcMod Scroll -.3 0
        //        blendFunc GL_ONE GL_ONE
        // }
     
}

sprites/plasma1
{
	cull disable
	{
		clampmap sprites/plasmaa.tga
		blendfunc GL_ONE GL_ONE
                tcMod rotate 931
	}
}

sprites/plasma2
{
	cull disable
	{
		map sprites/plasma2.tga
		blendfunc GL_ONE GL_ONE
	}
}

teleportEffect
{
	cull none
	{
		map gfx/misc/teleportEffect2.tga
                blendFunc GL_ONE GL_ONE
		rgbGen entity
		tcMod scale 1 4
		tcMod scroll 0 2
	}
}

// markShadow is the very cheap blurry blob underneat the player

markShadow
{
	polygonOffset
	{
		map gfx/damage/shadow.tga
		blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
		rgbGen exactVertex
	}	
}

// projectionShadow is used for cheap squashed model shadows

projectionShadow
{
	polygonOffset
	deformVertexes projectionShadow
	{
		map			*white
		blendFunc GL_ONE GL_ZERO
		rgbGen wave square 0 0 0 0				// just solid black
	}	
}


// wake is the mark on water surfaces for paddling players

wake
{
	{
		clampmap sprites/splash.tga
		blendFunc GL_ONE GL_ONE
		rgbGen vertex
                tcmod rotate 250
                tcMod stretch sin .9 0.1 0 0.7
		rgbGen wave sin .7 .3 .25 .5
	}	
        {
		clampmap sprites/splash.tga
		blendFunc GL_ONE GL_ONE
		rgbGen vertex
                tcmod rotate -230
                tcMod stretch sin .9 0.05 0 0.9
		rgbGen wave sin .7 .3 .25 .4
	}	
}


// viewBloodBlend gives the blended directional cue when you get hit

viewBloodBlend
{
	sort	nearest
	{
		//map models/weaphits/blood201.tga
                map gfx/damage/blood_screen.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identityLighting
		alphaGen vertex
	}
}

waterBubble
{
	sort	underwater
	cull none
	entityMergable		// allow all the sprites to be merged together
	{
		map sprites/bubble.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen		vertex
		alphaGen	vertex
	}
}

smokePuff
{
	cull none
	entityMergable		// allow all the sprites to be merged together
	{
		map gfx/misc/smokepuff3.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen		vertex
		alphaGen	vertex
	}
}

hasteSmokePuff			// drops behind player's feet when speeded
{
	cull none
	entityMergable		// allow all the sprites to be merged together
	{
		map gfx/misc/smokepuff3.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
                //blendfunc GL_ONE GL_ONE
		rgbGen		vertex
		alphaGen	vertex
	}
}

smokePuffRagePro
{
	cull none
	entityMergable		// allow all the sprites to be merged together
	{
		map gfx/misc/smokepuffragepro.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

snowPuff
{
	cull none
	entityMergable		// allow all the sprites to be merged together
	{
		map gfx/misc/snowpuff3.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen		vertex
		alphaGen	vertex
	}
}

shotgunSmokePuff
{
	cull none
	{
		map gfx/misc/smokepuff2b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen entity		
		rgbGen entity
	}
}

flareShader
{
	cull none
	{
		map gfx/misc/flare.tga
		blendFunc GL_ONE GL_ONE
		rgbGen vertex
	}
}

sun
{
	cull none
	{
		map gfx/misc/sun.tga
		blendFunc GL_ONE GL_ONE
		rgbGen vertex
	}
}

railDisc
{
	sort nearest
	cull none
        deformVertexes wave 100 sin 0 .5 0 2.4
	{
		clampmap gfx/misc/raildisc_mono2.tga 
		blendFunc GL_ONE GL_ONE
		rgbGen vertex
                 tcMod rotate -30
	}
}

railCore
{
	sort nearest
	cull none
	{
		map gfx/misc/railcorethin_mono.tga
		blendFunc GL_ONE GL_ONE
		rgbGen vertex
		tcMod scroll -1 0
	}
}

lightningBolt
{
	cull none
	{
		map gfx/misc/lightning3.tga
		blendFunc GL_ONE GL_ONE
//                rgbgen wave sin 1 5.1 0 7.1
                rgbgen wave sin 1 0.5 0 7.1
                 tcmod scale  2 1
		tcMod scroll -5 0
	}
    {
		map gfx/misc/lightning3.tga
		blendFunc GL_ONE GL_ONE
//                rgbgen wave sin 1 8.3 0 8.1
                rgbgen wave sin 1 0.8 0 8.1
                tcmod scale  -1.3 -1
		tcMod scroll -7.2 0
	}
}

// shader used on the occasional machinegun bullet tracers

gfx/misc/tracer
{
	cull none
	{
		map	gfx/misc/tracer2.tga
		blendFunc GL_ONE GL_ONE
	}
}

//
// wall marks
// use blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR so that
// their "contribution" can be damped down in fog volumes
// with distance

bloodMark
{
	nopicmip			// make sure a border remains
	polygonOffset
	{
		clampmap gfx/damage/blood_stain.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identityLighting
		alphaGen vertex
	}
}

bloodTrail
{
        
	nopicmip			// make sure a border remains
	entityMergable		// allow all the sprites to be merged together
	{
		//clampmap gfx/misc/blood.tga
                clampmap gfx/damage/blood_spurt.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen		vertex
		alphaGen	vertex
	}
}

gfx/damage/bullet_mrk
{
	polygonOffset
	{
		map gfx/damage/bullet_mrk.tga
		blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
		rgbGen exactVertex
	}
}

gfx/damage/burn_med_mrk
{
	polygonOffset
	{
		map gfx/damage/burn_med_mrk.tga
		blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
		rgbGen exactVertex
	}
}

gfx/damage/hole_lg_mrk
{
	polygonOffset
	{
		map gfx/damage/hole_lg_mrk.tga
		blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
		rgbGen exactVertex
	}
}

gfx/damage/plasma_mrk
{
	polygonOffset
	{
		map gfx/damage/plasma_mrk.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}

railDic
{
	cull disable
	deformVertexes autosprite
	{
		clampmap textures/oafx/plastrail.tga
		blendfunc gl_one gl_src_alpha
		rgbGen wave inversesawtooth 0 1 0 1.3 
		tcMod rotate -460
	}
	{
		clampmap textures/oafx/plastrail.tga
		blendfunc gl_one gl_src_alpha
		rgbGen wave inversesawtooth 0 1 0 1.3 
		tcMod rotate 754
	}
}

oldbulletExplosion
{
	cull disable
	{
		map models/weaphits/bulletscroll.tga
		blendfunc add
		tcMod scroll -1.4 0
	}
}

bitoutofdatebulletExplosion
{
	cull disable
	{
		map models/weaphits/bulletscroll2.tga
		blendfunc gl_one gl_src_alpha
		rgbGen wave inversesawtooth 0 1 0 2.8 
		tcMod scroll -1.5 0
	}
	{
		map models/weaphits/bulletscroll2.tga
		blendfunc gl_one gl_src_alpha
		rgbGen wave inversesawtooth 0 1 0 2.8 
		tcMod scroll -1.5 0
	}
}

bulletExplosion
{
	cull disable
	{
		animmap 12 models/weaphits/bullet_0000.tga models/weaphits/bullet_0001.tga models/weaphits/bullet_0002.tga models/weaphits/bullet_0003.tga models/weaphits/bullet_0004.tga models/weaphits/bullet_0005.tga models/weaphits/bullet_0006.tga models/weaphits/bullet_0007.tga 
		blendfunc add
	}
}

lightningExplosion
{
	cull disable
	deformVertexes wave 9 sin 0 1 0 9 
	{
		map models/weaphits/elecscroll.tga
		blendfunc add
		tcMod scroll -8 0
	}
}

bfgExplocsion
{
	cull disable
	{
		map models/weaphits/bfgscroll.tga
		blendfunc add
		tcMod scroll -1.4 0
	}
	{
		map models/weaphits/bfgscroll.tga
		blendfunc add
		tcMod scroll -0.6 0
	}
}

bfgExplosion
{
	{
		clampmap textures/oa/bfgfiar.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1.6 
		tcMod rotate 77
		tcMod stretch sin 0.3 0.7 0 0.6 
	}
	{
		clampmap textures/oa/bfgfiar.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1.6 
		tcMod rotate -17
		tcMod stretch sin 0 1.3 0 0.8 
	}
	{
		clampmap textures/oa/bfgfiar.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1.6 
		tcMod rotate -77
		tcMod stretch sawtooth 0 1.3 0 0.8 
	}
}

plasmaExplosion
{
	cull disable
	deformVertexes wave 1 sin 0 1 0 2 
	{
		clampmap models/weaphits/plasring.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1.6 
		tcMod stretch sawtooth 0 4.3 0 1.4 
		tcMod rotate -37
	}
	{
		clampmap models/weaphits/plasring.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1.6 
		tcMod stretch sawtooth 0 4.5 0 1.4 
		tcMod rotate 66
	}
}

railExplosion
{
	cull disable
	{
		clampmap models/weaphits/smokering2.tga
		blendfunc blend
		rgbGen lightingDiffuse
		tcMod stretch sawtooth 0 4.5 0 1.3 
		tcMod rotate -80
		alphaGen wave inversesawtooth 0 1 0 1.65 
	}
	{
		clampmap models/weaphits/smokering2.tga
		blendfunc blend
		rgbGen lightingDiffuse
		tcMod stretch sawtooth 0 4.5 0 1.4 
		tcMod rotate 66
		alphaGen wave inversesawtooth 0 1 0 1.65 
	}
	{
		clampmap models/weaphits/spark.tga
		blendfunc gl_src_alpha gl_one
		rgbGen identity
		tcMod stretch sawtooth 1.5 -3.5 0 1.1 
		tcMod rotate -80
		alphaGen wave inversesawtooth 0 1 0 1.65 
	}
}

OLDplasmaExplosion
{
	cull disable
	{
		map models/weaphits/plasscroll2.tga
		blendfunc add
		tcMod scroll -1.2 7
	}
}

OLDrailExplosion
{
	cull disable
	{
		map models/weaphits/railscroll.tga
		blendfunc blend
		rgbGen lightingDiffuse
		tcMod scroll -1 -0.06
	}
	{
		map models/weaphits/plasscroll2.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 0.6 
		tcMod scroll 0 1
	}
}

OLDrocketExplosion
{
	{
		clampmap textures/oa/fiar.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1 
		tcMod rotate 77
		tcMod stretch sin 0.3 0.4 0 0.4 
	}
	{
		clampmap textures/oa/fiar2.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1 
		tcMod rotate 33
		tcMod stretch sin 0.8 -0.4 0 0.1 
	}
	{
		clampmap textures/oa/fiar.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1 
		tcMod rotate -17
	}
	{
		clampmap textures/oa/fiar2.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1 
		tcMod rotate -77
	}
}

bloodExplosion
{
	{
		clampmap gfx/2d/bloodspew.tga
		blendfunc blend
		tcMod rotate 77
		tcMod stretch sin 0 2 0 0.4 
		alphaGen wave inversesawtooth 0 1 0 1 
	}
	{
		clampmap gfx/2d/bloodspew.tga
		blendfunc blend
		tcMod rotate -43
		tcMod stretch sin 0 1.7 0 0.4 
		alphaGen wave inversesawtooth 0 1 0 1 
	}
}

olderrocketExplosion
{
	{
		clampmap textures/oa/fiar.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1 
		tcMod rotate 77
		tcMod stretch sin 0 1 0 0.4 
	}
	{
		clampmap textures/oa/fiar2.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1 
		tcMod rotate 33
		tcMod stretch sin 0 1 0 0.4 
	}
	{
		clampmap textures/oa/fiar.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1 
		tcMod rotate -17
		tcMod stretch sawtooth 0 1.8 0 1 
	}
	{
		clampmap textures/oa/fiar2.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1 
		tcMod rotate -77
		tcMod stretch sawtooth 0.3 1 0 1 
	}
}

rocketExplosion
{
	{
		animmap 8 models/weaphits/rlboom/rlboom_1.tga models/weaphits/rlboom/rlboom_2.tga models/weaphits/rlboom/rlboom_3.tga models/weaphits/rlboom/rlboom_4.tga models/weaphits/rlboom/rlboom_5.tga models/weaphits/rlboom/rlboom_6.tga models/weaphits/rlboom/rlboom_7.tga models/weaphits/rlboom/rlboom_8.tga 
		blendfunc gl_one gl_src_alpha
		rgbGen wave inversesawtooth 0 1 0 8 
	}
	{
		animmap 8 models/weaphits/rlboom/rlboom_2.tga models/weaphits/rlboom/rlboom_3.tga models/weaphits/rlboom/rlboom_4.tga models/weaphits/rlboom/rlboom_5.tga models/weaphits/rlboom/rlboom_6.tga models/weaphits/rlboom/rlboom_7.tga models/weaphits/rlboom/rlboom_8.tga models/weaphits/rlboom/rlboom_8.tga 
		blendfunc gl_one gl_src_alpha
		rgbGen wave sawtooth 0 1 0 8 
	}
	{
		clampmap textures/oa/fiar.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1 
		tcMod rotate 77
		tcMod stretch sawtooth 0 1 0 0.4 
	}
	{
		clampmap textures/oa/fiar2.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1 
		tcMod rotate 33
		tcMod stretch sin 0 1 0 0.4 
	}
	{
		clampmap textures/oa/fiar.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1 
		tcMod rotate -17
		tcMod stretch sawtooth 0 1.5 0 1 
	}
	{
		clampmap textures/oa/fiar2.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1 
		tcMod rotate -77
		tcMod stretch sawtooth 0.3 1 0 1 
	}
}

lasmaExplosion
{
	cull disable
	{
		clampmap textures/oa/fiar.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 4 
		tcMod rotate 300
		tcMod stretch sin 0.3 0.4 0 0.4 
	}
	{
		clampmap textures/oa/fiar2.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 4 
		tcMod rotate 122
		tcMod stretch sin 0.8 -0.7 0 0.1 
	}
}

ailExplosion
{
	cull disable
	{
		clampmap textures/oa/fiar.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1 
		tcMod rotate 12
		tcMod stretch sin 0.3 0.4 0 0.4 
	}
	{
		clampmap textures/oa/fiar2.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1 
		tcMod rotate 15
		tcMod stretch sin 0.8 -0.4 0 0.1 
	}
	{
		clampmap textures/oa/fiar.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1 
		tcMod rotate -12
	}
	{
		clampmap textures/oa/fiar2.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1 
		tcMod rotate -78
	}
}

OLDgrenadeExplosion
{
	{
		clampmap textures/oa/grenfiar.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1.6 
		tcMod rotate 77
		tcMod stretch sin 0.3 0.4 0 0.4 
	}
	{
		clampmap textures/oa/grenfiar.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1.6 
		tcMod rotate 33
		tcMod stretch sin 0.8 -0.4 0 0.4 
	}
	{
		clampmap textures/oa/grenfiar.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1.6 
		tcMod rotate -17
	}
	{
		clampmap textures/oa/grenfiar.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1.6 
		tcMod rotate -77
	}
}

grenadeExplosion
{
	{
		clampmap textures/oa/grenfiar.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1.6 
		tcMod rotate 77
		tcMod stretch sin 0 1 0 0.4 
	}
	{
		clampmap textures/oa/grenfiar.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1.6 
		tcMod rotate 33
		tcMod stretch sin 0 1 0 0.4 
	}
	{
		clampmap textures/oa/grenfiar.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1.6 
		tcMod rotate -17
		tcMod stretch sawtooth 0 1.8 0 1 
	}
	{
		clampmap textures/oa/grenfiar.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 1.6 
		tcMod rotate -77
		tcMod stretch sawtooth 0.3 1 0 1 
	}
}

// ------------------------------------------------------------
// 11.scoreboard
// ------------------------------------------------------------

scoreboardName
{
	nopicmip
	nomipmaps
	{
		clampmap menu/tab/name.tga
		blendfunc blend
	}
}

scoreboardScore
{
	nopicmip
	nomipmaps
	{
		clampmap menu/tab/score.tga
		blendfunc blend
	}
}

scoreboardTime
{
	nopicmip
	nomipmaps
	{
		clampmap menu/tab/time.tga
		blendfunc blend
	}
}

scoreboardPing
{
	nopicmip
	nomipmaps
	{
		clampmap menu/tab/ping.tga
		blendfunc blend
	}
}

// ------------------------------------------------------------
// 13.characters and numbers
// ------------------------------------------------------------

gfx/2d/bigchars
{
	nopicmip
	nomipmaps
	{
		map gfx/2d/bigchars.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen vertex
	}
}

gfx/2d/bigchars_plates
{
	nopicmip
	nomipmaps
	{
		map gfx/2d/bigchars_plates.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen vertex
	}
}

gfx/2d/select
{
	nopicmip
	{
		map gfx/2d/select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		rgbgen vertex
	}
}

gfx/2d/assault1d
{
	nopicmip
	{
		map gfx/2d/assault1d.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

gfx/2d/armor1h
{
	nopicmip
	{
		map gfx/2d/armor1h.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

gfx/2d/health
{
	nopicmip
	{
		map gfx/2d/health.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

gfx/2d/blank
{
	nopicmip
	{
		map gfx/2d/blank.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

gfx/2d/numbers/zero_32b
{
	nopicmip
	{
		map gfx/2d/numbers/zero_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen vertex
	}
}

gfx/2d/numbers/one_32b
{
	nopicmip
	{
		map gfx/2d/numbers/one_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen vertex
	}
}

gfx/2d/numbers/two_32b
{
	nopicmip
	{
		map gfx/2d/numbers/two_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen vertex
	}
}

gfx/2d/numbers/three_32b
{
	nopicmip
	{
		map gfx/2d/numbers/three_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen vertex
	}
}

gfx/2d/numbers/four_32b
{
	nopicmip
	{
		map gfx/2d/numbers/four_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen vertex
	}
}

gfx/2d/numbers/five_32b
{
	nopicmip
	{
		map gfx/2d/numbers/five_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen vertex
	}
}

gfx/2d/numbers/six_32b
{
	nopicmip
	{
		map gfx/2d/numbers/six_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen vertex
	}
}

gfx/2d/numbers/seven_32b
{
	nopicmip
	{
		map gfx/2d/numbers/seven_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen vertex
	}
}

gfx/2d/numbers/eight_32b
{
	nopicmip
	{
		map gfx/2d/numbers/eight_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen vertex
	}
}

gfx/2d/numbers/nine_32b
{
	nopicmip
	{
		map gfx/2d/numbers/nine_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen vertex
	}
}

gfx/2d/numbers/minus_32b
{
	nopicmip
	{
		map gfx/2d/numbers/minus_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen vertex
	}
}

// ------------------------------------------------------------
// 14.explosions
// ------------------------------------------------------------

plasmaExplosion
{
	cull disable
	{
		clampmap models/weaphits/plasmaboom.tga
		blendfunc add
                tcMod stretch triangle .6 0.1 0 8
                tcmod rotate 999
                rgbGen wave inversesawtooth 0 1 0 1.5
	}
}

railExplosion
{
	cull disable
        {
		animmap 5 models/weaphits/ring02_1.tga  models/weaphits/ring02_2.tga  models/weaphits/ring02_3.tga models/weaphits/ring02_4.tga gfx/colors/black.tga
		alphaGen wave inversesawtooth 0 1 0 5
		blendfunc blend
	}
	{
		animmap 5 models/weaphits/ring02_2.tga  models/weaphits/ring02_3.tga models/weaphits/ring02_4.tga gfx/colors/black.tga gfx/colors/black.tga
		alphaGen wave sawtooth 0 1 0 5
		blendfunc blend
	}
}

lightningExplosion
{
	cull disable
	{
		animmap 5 models/weaphits/ring02_1.tga  models/weaphits/ring02_3.tga  models/weaphits/ring02_3.tga gfx/colors/black.tga
		rgbGen wave inversesawtooth 0 1 0 5
		blendfunc add
	}
	{
		animmap 5 models/weaphits/ring02_2.tga  models/weaphits/ring02_3.tga  gfx/colors/black.tga gfx/colors/black.tga
		rgbGen wave sawtooth 0 1 0 5
		blendfunc add
	}
}

bulletExplosion
{
	cull disable
	{
		animmap 5 models/weaphits/bullet1.tga  models/weaphits/bullet2.tga  models/weaphits/bullet3.tga gfx/colors/black.tga
		rgbGen wave inversesawtooth 0 1 0 5
		blendfunc add
	}
	{
		animmap 5 models/weaphits/bullet2.tga  models/weaphits/bullet3.tga  gfx/colors/black.tga gfx/colors/black.tga
		rgbGen wave sawtooth 0 1 0 5
		blendfunc add
	}
}

rocketExplosion
{
	cull disable
	{
		animmap 8 models/weaphits/rlboom/rlboom_1.tga  models/weaphits/rlboom/rlboom_2.tga models/weaphits/rlboom/rlboom_3.tga models/weaphits/rlboom/rlboom_4.tga models/weaphits/rlboom/rlboom_5.tga models/weaphits/rlboom/rlboom_6.tga models/weaphits/rlboom/rlboom_7.tga models/weaphits/rlboom/rlboom_8.tga
		rgbGen wave inversesawtooth 0 1 0 8
		blendfunc add
	}
	{
		animmap 8 models/weaphits/rlboom/rlboom_2.tga models/weaphits/rlboom/rlboom_3.tga models/weaphits/rlboom/rlboom_4.tga models/weaphits/rlboom/rlboom_5.tga models/weaphits/rlboom/rlboom_6.tga models/weaphits/rlboom/rlboom_7.tga models/weaphits/rlboom/rlboom_8.tga gfx/colors/black.tga
		rgbGen wave sawtooth 0 1 0 8
		blendfunc add
	}
}

grenadeExplosion
{
	cull disable
	{
		animmap 5 models/weaphits/glboom/glboom_1.tga  models/weaphits/glboom/glboom_2.tga models/weaphits/glboom/glboom_3.tga
		rgbGen wave inversesawtooth 0 1 0 5
		blendfunc add
	}
	{
		animmap 5 models/weaphits/glboom/glboom_2.tga  models/weaphits/glboom/glboom_3.tga gfx/colors/black.tga
		rgbGen wave sawtooth 0 1 0 5
		blendfunc add
	}
}

bfgExplosion
{
	cull disable
	{
		animmap 5 models/weaphits/bfgboom/bfgboom_1.tga  models/weaphits/bfgboom/bfgboom_2.tga models/weaphits/bfgboom/bfgboom_3.tga
		rgbGen wave inversesawtooth 0 1 0 5
		blendfunc add
	}
	{
		animmap 5 models/weaphits/bfgboom/bfgboom_2.tga models/weaphits/bfgboom/bfgboom_3.tga gfx/colors/black.tga
		rgbGen wave sawtooth 0 1 0 5
		blendfunc add
	}
}

bloodExplosion		// spurt of blood at point of impact
{
	cull disable
	{
		animmap 5 models/weaphits/blood201.tga models/weaphits/blood202.tga models/weaphits/blood203.tga models/weaphits/blood204.tga models/weaphits/blood205.tga
		blendfunc blend
	}
}

textures/sfx/flame1
{
	surfaceparm nomarks
	surfaceparm nolightmap
	surfaceparm trans
	cull none
	q3map_surfacelight 7500
	

	{
		animMap 10 textures/sfx/flame1.tga textures/sfx/flame2.tga textures/sfx/flame3.tga textures/sfx/flame4.tga textures/sfx/flame5.tga textures/sfx/flame6.tga textures/sfx/flame7.tga textures/sfx/flame8.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave inverseSawtooth 0 1 0 10
		
	}	
	{
		animMap 10 textures/sfx/flame2.tga textures/sfx/flame3.tga textures/sfx/flame4.tga textures/sfx/flame5.tga textures/sfx/flame6.tga textures/sfx/flame7.tga textures/sfx/flame8.tga textures/sfx/flame1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sawtooth 0 1 0 10
	}	


	{
		map textures/sfx/flameball.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin .6 .2 0 .6	
	}

}

textures/sfx/flame2
{
	surfaceparm nomarks
	surfaceparm nolightmap
	surfaceparm trans
	cull none
	q3map_surfacelight 7500
	

	{
		animMap 10 textures/sfx/flame1.tga textures/sfx/flame2.tga textures/sfx/flame3.tga textures/sfx/flame4.tga textures/sfx/flame5.tga textures/sfx/flame6.tga textures/sfx/flame7.tga textures/sfx/flame8.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave inverseSawtooth 0 1 0 10
		
	}	
	{
		animMap 10 textures/sfx/flame2.tga textures/sfx/flame3.tga textures/sfx/flame4.tga textures/sfx/flame5.tga textures/sfx/flame6.tga textures/sfx/flame7.tga textures/sfx/flame8.tga textures/sfx/flame1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sawtooth 0 1 0 10
	}	


	{
		map textures/sfx/flameball.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin .6 .2 0 .6	
	}

}

// ------------------------------------------------------------
// 15.camera flash
// ------------------------------------------------------------

textures/stecki/cameraflash_01
{
	qer_editorimage textures/stecki/cameraflash_01.tga
      surfaceparm nomarks	
      surfaceparm nonsolid
	surfaceparm nolightmap
	deformVertexes autosprite

	{
	animMap 2 textures/stecki/cameraflash_01.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga
		blendFunc add
		rgbGen wave Inversesawtooth 0 2 0 2
//		rgbGen wave Inversesawtooth 1 1 0 1
	}
}

textures/stecki/cameraflash_02
{
	qer_editorimage textures/stecki/cameraflash_01.tga
      surfaceparm nomarks	
      surfaceparm nonsolid
	surfaceparm nolightmap
	deformVertexes autosprite

	{
	animMap 2 textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_01.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga
		blendFunc add
		rgbGen wave Inversesawtooth 0 2 0 2
//		rgbGen wave Inversesawtooth 1 1 0 1
	}
}

textures/stecki/cameraflash_03
{
	qer_editorimage textures/stecki/cameraflash_01.tga
      surfaceparm nomarks	
      surfaceparm nonsolid
	surfaceparm nolightmap
	deformVertexes autosprite

	{
	animMap 2 textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_01.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga
		blendFunc add
		rgbGen wave Inversesawtooth 0 2 0 2
//		rgbGen wave Inversesawtooth 1 1 0 1
	}
}

textures/stecki/cameraflash_04
{
	qer_editorimage textures/stecki/cameraflash_01.tga
      surfaceparm nomarks	
      surfaceparm nonsolid
	surfaceparm nolightmap
	deformVertexes autosprite

	{
	animMap 2 textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_01.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga
		blendFunc add
		rgbGen wave Inversesawtooth 0 2 0 2
//		rgbGen wave Inversesawtooth 1 1 0 1
	}
}

textures/stecki/cameraflash_05
{
	qer_editorimage textures/stecki/cameraflash_01.tga
      surfaceparm nomarks	
      surfaceparm nonsolid
	surfaceparm nolightmap
	deformVertexes autosprite

	{
	animMap 2 textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_01.tga textures/stecki/cameraflash_02.tga
		blendFunc add
		rgbGen wave Inversesawtooth 0 2 0 2
//		rgbGen wave Inversesawtooth 1 1 0 1
	}
}

textures/stecki/cameraflash
{
	qer_editorimage textures/stecki/cameraflash_01.tga
      surfaceparm nomarks	
      surfaceparm nonsolid
	surfaceparm nolightmap
	deformVertexes autosprite

	{
	animMap 2 textures/stecki/cameraflash_01.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga
		blendFunc add
		rgbGen wave Inversesawtooth 0 2 0 2
//		rgbGen wave Inversesawtooth 1 1 0 1
	}
}

textures/stecki/cameraflash2
{
	qer_editorimage textures/stecki/cameraflash_01.tga
      surfaceparm nomarks	
      surfaceparm nonsolid
	surfaceparm nolightmap
	deformVertexes autosprite

	{
	animMap 2 textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_01.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga
		blendFunc add
		rgbGen wave Inversesawtooth 0 2 0 2
//		rgbGen wave Inversesawtooth 1 1 0 1
	}
}

textures/stecki/cameraflash3
{
	qer_editorimage textures/stecki/cameraflash_01.tga
      surfaceparm nomarks	
      surfaceparm nonsolid
	surfaceparm nolightmap
	deformVertexes autosprite

	{
	animMap 2 textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_01.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga
		blendFunc add
		rgbGen wave Inversesawtooth 0 2 0 2
//		rgbGen wave Inversesawtooth 1 1 0 1
	}
}

textures/stecki/cameraflash4
{
	qer_editorimage textures/stecki/cameraflash_01.tga
      surfaceparm nomarks	
      surfaceparm nonsolid
	surfaceparm nolightmap
	deformVertexes autosprite

	{
	animMap 2 textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_01.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga
		blendFunc add
		rgbGen wave Inversesawtooth 0 2 0 2
//		rgbGen wave Inversesawtooth 1 1 0 1
	}
}

textures/stecki/cameraflash5
{
	qer_editorimage textures/stecki/cameraflash_01.tga
      surfaceparm nomarks	
      surfaceparm nonsolid
	surfaceparm nolightmap
	deformVertexes autosprite

	{
	animMap 2 textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_02.tga textures/stecki/cameraflash_01.tga textures/stecki/cameraflash_02.tga
		blendFunc add
		rgbGen wave Inversesawtooth 0 2 0 2
//		rgbGen wave Inversesawtooth 1 1 0 1
	}
}

// ------------------------------------------------------------
// 16.ufo gfx
// ------------------------------------------------------------

textures/q3r_sfx/force_green

{
	qer_editorimage models/mapobjects/ufo/ufo01glow.tga
	cull disable
	surfaceparm alphashadow
	surfaceparm playerclip
       {
	        map models/mapobjects/ufo/ufo01glow.tga
		tcMod scroll 2.1 0
		blendFunc add
               rgbGen wave sin 1 1 .5 .1
       }
      {
	        map models/mapobjects/ufo/ufo01glow.tga
		tcMod scroll 1.4 0
		blendFunc add
               rgbGen wave square 1 1 .5 2
       }
      {
	        map models/mapobjects/ufo/ufo01glow.tga
		tcMod scroll -.9 0
		blendFunc add
               rgbGen wave square 1 1 .25 .5
       }


}

// ------------------------------------------------------------
// 17.stecki gfx
// ------------------------------------------------------------

textures/stecki/haze
{
	qer_editorimage textures/stecki/haze_rt.tga
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_sun 1 .992 .879 80 38 30
	q3map_surfacelight 50
	skyparms textures/stecki/haze - -
}

//stecki haze fog

textures/stecki/fog_haze
{
qer_editorimage textures/sfx/fog_grey.tga
surfaceparm	trans
surfaceparm	nonsolid
surfaceparm	fog
surfaceparm	nolightmap

fogparms ( .477 .477 .479 ) 400

}

textures/stecki/night01
{
	qer_editorimage textures/stecki/night01_up.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
//        q3map_lightimage textures/stecki/night01_up.tga
	q3map_sun	.9 .8 1 30 30 60
	q3map_surfacelight 5

        skyparms textures/stecki/night01 512 textures/stecki/night01

}

textures/stecki/decal01
{
	qer_editorimage gfx/damage/plasma_mrk.tga
	polygonOffset
	{
		map gfx/damage/plasma_mrk.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}

// ------------------------------------------------------------
// 18.teleporter
// ------------------------------------------------------------

teleptThis
{
	surfaceparm nolightmap
	cull disable
	deformVertexes autosprite
	{
		clampmap textures/flares/newflare.tga
		blendfunc add
		rgbGen wave sawtooth 0 1 0 2 
		tcMod stretch inversesawtooth 0 1 0 2 
		tcMod rotate 333
	}
	{
		clampmap textures/flares/lava.tga
		blendfunc add
		rgbGen wave sawtooth 0 1 0 0.5 
		tcMod stretch inversesawtooth 0 1 0 0.5 
		tcMod rotate -333
	}
	{
		clampmap textures/flares/newflare.tga
		blendfunc add
		rgbGen wave sawtooth 0 1 0 1.25 
		tcMod stretch inversesawtooth 0 1 0 1.25 
		tcMod rotate 500
	}
	{
		clampmap textures/flares/portalflare.tga
		blendfunc add
		rgbGen wave inversesawtooth 0 1 0 4 
		tcMod stretch sawtooth 0 1 0 4 
		tcMod rotate 1323
	}
}

teleptThat
{
	q3map_lightimage textures/effects/jumpcirc.tga
	surfaceparm nolightmap
	cull disable
	deformVertexes autosprite
	q3map_surfacelight 300
	{
		clampmap textures/effects/jumpcirc.tga
		blendfunc add
		rgbGen wave sawtooth 0 1 0 2 
		tcMod stretch inversesawtooth 0 1 0 2 
		tcMod rotate 333
	}
	{
		clampmap textures/effects/jumpcirc.tga
		blendfunc add
		rgbGen wave sawtooth 0 1 0 0.5 
		tcMod stretch inversesawtooth 0 1 0 0.5 
		tcMod rotate -333
	}
	{
		clampmap textures/effects/jumpcirc.tga
		blendfunc add
		rgbGen wave sawtooth 0 1 0 1.25 
		tcMod stretch inversesawtooth 0 1 0 1.25 
		tcMod rotate 500
	}
}

// ------------------------------------------------------------
// 19.car gfx
// ------------------------------------------------------------

gfx/flares/blite
{
	deformVertexes autosprite

	{
		map gfx/flares/blite.tga
		blendFunc add
		rgbGen identity
	}
}

gfx/flares/hlite
{
	deformVertexes autosprite

	{
		map gfx/flares/hlite.tga
		blendFunc add
		rgbGen identity
	}
}

gfx/flares/rlite
{
	deformVertexes autosprite

	{
		map gfx/flares/rlite.tga
		blendFunc add
		rgbGen identity
	}
}
gfx/skidmarks/asphalt
{
	polygonOffset
	{
		map gfx/skidmarks/asphalt.tga
		blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
		rgbGen exactVertex
	}
}
gfx/skidmarks/grass
{
	polygonOffset
	{
		map gfx/skidmarks/grass.tga
		blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
		rgbGen exactVertex
	}
}
gfx/skidmarks/dirt
{
	polygonOffset
	{
		map gfx/skidmarks/dirt.tga
		blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
		rgbGen exactVertex
	}
}
gfx/skidmarks/flesh
{
	polygonOffset
	{
		map gfx/skidmarks/flesh.tga
		blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
		rgbGen exactVertex
	}
}
gfx/damage/spark
{
	sort nearest
	cull none
	{
		map gfx/damage/spark.jpg
		blendFunc GL_ONE GL_ONE
		rgbGen vertex
	}
}

gfx/damage/oil_mark
{
	polygonOffset


	{
		map gfx/damage/oil_mark.tga
		blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
		rgbGen exactVertex
	}
	{	
	      map textures/reflect/oilreflect.tga
		blendFunc add
	      rgbGen exactVertex
	}
	{
		map gfx/damage/oil_mark_reflect.tga
		blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
		rgbGen exactVertex
	}
}

// ------------------------------------------------------------
// 20.goal gfx
// ------------------------------------------------------------

textures/sfx2/redgoal2
{
	surfaceparm nolightmap
	surfaceparm trans
	cull none
	{
		map textures/sfx2/redgoal2.tga
		tcgen environment
		blendfunc add
		tcmod turb .1 .3 .5 .4
		tcmod scale .5 .5
	}
}

textures/sfx2/bluegoal2
{
	surfaceparm nolightmap
	surfaceparm trans
	cull none
	{
		map textures/sfx2/bluegoal2.tga
		tcgen environment
		blendfunc add
		tcmod turb .1 .3 .5 .4
		tcmod scale .5 .5
	}
}

// ------------------------------------------------------------
// 21.car gibs
// ------------------------------------------------------------

models/gibs/muffler

{

	{
            map textures/sfx/specular.tga
		tcGen environment
	}
	{
		map models/gibs/gibs.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

models/gibs/piston

{

	{
            map textures/sfx/specular.tga
		tcGen environment
	}
	{
		map models/gibs/gibs.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}


models/gibs/shock

{
	cull disable
	{
		map models/gibs/gibs.tga
		blendFunc blend
		alphaFunc GE128
		depthWrite
	}
}

models/gibs/steer

{
	{
		map models/gibs/gibs.tga
		blendFunc blend
		alphaFunc GE128
		depthWrite
	}
}

// ------------------------------------------------------------
// 22.Torch
// ------------------------------------------------------------

models/mapobjects/gratelamp/gratetorch2b
{
	{
		map models/mapobjects/gratelamp/gratetorch2b.tga
		blendfunc blend
    }
}

textures/sfx/beam_dusty2
{
	qer_editorimage textures/sfx/beam.tga
        surfaceparm trans	
        surfaceparm nomarks	
        surfaceparm nonsolid
	surfaceparm nolightmap
	cull none
	surfaceparm nomipmaps
        //nopicmip
	{
		map textures/sfx/beam_1.tga
           //     tcMod Scroll .3 0
                blendFunc add
        }
 //        {
//		map textures/sfx/beamdust.tga
//		tcmod scale 2 2
//		tcMod turb 0 0.015 0.025 0.05
 //               tcMod Scroll -0.15 0
   //             blendFunc GL_ONE GL_ONE
   //      }
     	//{
	//	map textures/sfx/beam_mask.tga
        //        blendFunc GL_DST_COLOR GL_ONE_MINUS_SRC_COLOR  
      //	}
}

